/*******************************************************************************************************************/
/* THIS SCRIPT NEEDS TO BE EXECUTED AFTER SCRIPT "VoxcoProject_Update907.sql" WHICH CREATES TABLE "Appearance"     */
/*                                                                                                                 */
/* This script will read VoxcoSystem.dbo.tblpages table to get all kind 1002 entries for each module               */
/* 1. Builds a temp table containing all Database Id that have entries of kind 1002 for them                       */
/* 2. Cursor to loop through each database, update Appearance table of database with all 1002 kind entries         */
/*******************************************************************************************************************/

-- Refresh the VIEW Structure on VoxcoSystem.tblObjects table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'tblObjects') 
    DROP View [dbo].[tblObjects] 
GO
create view dbo.tblObjects as select * from #VoxcoSystemDatabaseName#.dbo.tblObjects
GO

-- Refresh the VIEW Structure on VoxcoSystem.tblPages table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'tblPages') 
    DROP View [dbo].[tblPages] 
GO
create view dbo.tblPages as select * from #VoxcoSystemDatabaseName#.dbo.tblPages
GO



CREATE TABLE #databaseToBeUpdated(DataBaseId nvarchar(max), NumberOfRecords int)
 
INSERT INTO #databaseToBeUpdated
SELECT	ltrim(rtrim(P.StaticValue)) AS DataBaseId,
		count(*) AS NumberOfRecords
		FROM tblobjects O
		JOIN tblpages PA			ON  PA.k_id = O.k_Id
							AND PA.Kind = 1002
		JOIN tblpages P				ON  P.k_id = O.ParentId
							AND P.kind = 12000
							AND P.Name = 'InterviewerProjectId'
		GROUP BY P.StaticValue
		ORDER BY 1

PRINT 'Number of Voxco_Project database to be updated ' + convert(varchar(max),@@ROWCOUNT) 
PRINT '--------------------------------------------------------------------------'

DECLARE @query VARCHAR(max)
SET @query = '';

DECLARE @DataBaseId VARCHAR(max)
DECLARE @NumberOfRecords int

DECLARE DBCursor CURSOR
FOR         SELECT DataBaseId,NumberOfRecords FROM #databaseToBeUpdated
OPEN DBCursor
FETCH DBCursor INTO @DataBaseId, @NumberOfRecords
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @query = N'IF EXISTS (SELECT 1 
           FROM Voxco_Project_' + @DataBaseId + '.INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_TYPE=''BASE TABLE'' 
           AND TABLE_NAME=''Appearance'') 
BEGIN
	PRINT ''Number of Records to be updated ' + convert(nvarchar(max),@NumberOfRecords) + ''' 
	INSERT INTO Voxco_Project_' + @DataBaseId + '.[dbo].[Appearance] (ModuleId, PropertyName, PropertyValue, modifiedBy, modified) 
	SELECT	O.k_Id AS ModuleId,
			PA.Name AS PropertyName, 
			Case when CAST (isnull(PA.DynamicValue,'''') AS nvarchar(max)) = ''''
				Then ISNULL(PA.StaticValue,'''')
				Else CAST (isnull(PA.DynamicValue,'''') AS nvarchar(max)) END AS PropertyValue,
			8 as modifiedBy, 
			getutcdate() as modified
			FROM tblobjects O
			JOIN tblpages PA			ON  PA.k_id = O.k_Id
								AND PA.Kind = 1002
			JOIN dbo.tblpages P			ON  P.k_id = O.ParentId
								AND P.kind = 12000
								AND P.Name = ''InterviewerProjectId''
								AND P.StaticValue = ''' + @DataBaseId + '''
			WHERE not exists (SELECT 1 from Voxco_Project_' + @DataBaseId + '.[dbo].[Appearance] A where A.ModuleId = O.k_id and A.PropertyName = PA.Name)				
	PRINT ''Appearance table in Voxco_Project_' + @DataBaseId + ' as been updated'' 
END 
ELSE 
BEGIN 
	PRINT ''Appearance table in Voxco_Project_' + @DataBaseId + ' does not exist'' 
END ';

exec  (@query);
											
FETCH DBCursor INTO @DataBaseId, @NumberOfRecords
END
CLOSE DBCursor
DEALLOCATE DBCursor
drop table #databaseToBeUpdated
GO

